#!/bin/bash

if [ $# -ne 1 ]; then
   echo "Usage: $0 directory"
fi

lines=""
filename=""
directory=$1
Request_Percentage=70
function echoFormatLine(){
   percent=${1##*:}
   range=${percent%%.*}
   if [ "$range" -le "$Request_Percentage" ];then
      echo -e "\033[31;49;1m$lines\033[0m"
   else
      echo $lines	  
   fi
}


function parseLine(){
   if [ "$1" == "File" ];then
      echo $lines
	  return
   fi
   
   if [ "$1" == "Lines" ];then
      echoFormatLine $2
	  return
   fi	
   
   if [ "$1" == "Branches" ];then
      echoFormatLine $2
	  return
   fi
   
   if [ "$1" == "Taken" ];then
      echoFormatLine $4
	  return
   fi
   
   if [ "$1" == "Calls" ];then
      echoFormatLine $2
	  return
   fi
}

find $directory -name "*.c" -type f |while read file;do
   filename=${file#$directory/}

   if [ ! -f "${file/%.c/.gcno}" ];then
      echo -e "\033[31;49;1m$filename was not covered by unit tests !\033[0m"
   else
      echo
      gcov -b $file | while read lines;do
		  parseLine $lines
      done
	  echo 
   fi
done
	

